﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.Instructor
{
    public partial class FInstructorSearch : PI.FM.N000.Base.WinForms.Controls.FSearchTemplate
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        public FInstructorSearch()
        {
            InitializeComponent();

            this._gComboBoxTop.SetDataSourceStringList(new string[] {
                "50",
                "100",
                "250",
                "500",
                "1000"
               });
        }

        public BL.BO.Instructor.Search Search
        {
            get { return (BL.BO.Instructor.Search)_search; }
            set 
            { 
                _search = value;
                LoadSearch();
            }
        }

        private void LoadSearch()
        {
            if (Search == null) 
            {
                Search = new BL.BO.Instructor.Search();
            }


            base.LoadTop(Search.Top, _gComboBoxTop, _gCheckBoxTop);
            base.LoadString(Search.Forename, _gTextBoxForename, _gCheckBoxForename);
            base.LoadString(Search.Surename, _gTextBoxSurename, _gCheckBoxSurename);
            base.LoadString(Search.Email, _gTextBoxEmail, _gCheckBoxEmail);
            base.LoadButtonEdit(Search.SchoolID, BLZSBELearning.School, AddSchool, true, _gButtonEditDALSchoolID, _gCheckBoxSchoolID);
        }

        private void SaveSearch()
        {
            Search.Top = base.SaveTop(_gComboBoxTop, _gCheckBoxTop);
            Search.Forename = base.SaveString(_gTextBoxForename, _gCheckBoxForename);
            Search.Surename = base.SaveString(_gTextBoxSurename, _gCheckBoxSurename);
            Search.Email = base.SaveString(_gTextBoxEmail, _gCheckBoxEmail);
            Search.SchoolID = base.SaveButtonEdit(_gButtonEditDALSchoolID, _gCheckBoxSchoolID);
        }


        private void ButtonCancell_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.Cancel;
            Close();
        }

        private void ButtonOK_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.OK;
            SaveSearch();
            Close();
        }

        private Gemini.Core.BL.Interface.BO.IBaseUnique<long?> AddSchool()
        {
            FM.N000.Base.WinForms.Classes.Param _param = new FM.N000.Base.WinForms.Classes.Param(Gemini.Core.WinForms.Interface.ShowMode.ModalWindow);
            BL.BO.School.Search _search = new BL.BO.School.Search();
            Environment.WindowsHandler.Show(BL.Dictionary.WinFormsName, new Gemini.Core.WinForms.Base.AccessDescription(BL.Dictionary.Objects.UI.SchoolList), _param, _search);

            return _param.Object;
        }
    }
}
